;; small program: (if ((loop ((x * x) * y) (2 * (2 + 2)) 1) mod (1 + x)) <= 0 then 1 else 0)
;; K K F L F C C C D F B J B K D H B A I
;; fast program: (if ((loop ((((x * x) * x) * x) * x) 1 (loop ((x * x) + x) 2 (2 + 2))) mod (1 + x)) <= 0 then 1 else 0)
;; K K F K F K F K F B K K F K D C C C D J J B K D H B A I
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun g2 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 () Int)
(declare-fun v2 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g1 1))
(assert (= h0 1))
(assert (= g2 2))
(assert (= h2 (+ 2 2)))
(assert (forall ((x Int)) (= (f2 x) (+ (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* (* x x) y))))
(assert (= g0 (* 2 (+ 2 2))))
(assert (forall ((x Int)) (= (f1 x) (* (* (* (* x x) x) x) x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (= h1 v2))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int)) (= (small x) (ite (<= (modf v0 (+ 1 x)) 0) 1 0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (fast x) (ite (<= (modf v1 (+ 1 x)) 0) 1 0))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
