;; small program: (loop (((2 + (x mod y)) mod x) + y) x 1)
;; C K L H D K H L D K B J
;; fast program: (((loop 2 (2 + (2 - x)) x) - 2) + (if x <= 0 then 1 else x))
;; C C C K E D K J C E K B K I D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= f1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g1 x) (+ 2 (- 2 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (modf (+ 2 (modf x y)) x) y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (fast x) (+ (- (v1 x) 2) (ite (<= x 0) 1 x)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
