;; small program: (loop (loop (x * x) 1 (loop ((x * y) div (y - (y div 2))) (y - 1) 2)) x 1)
;; K K F B K L F L L C G E G L B E C J J K B J
;; fast program: (loop (x * x) 1 (loop (2 * ((x - (x div y)) + x)) (x div 2) (1 + (x mod 2))))
;; K K F B C K K L G E K D F K C G B K C H D J J
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun f3 (Int) Int)
(declare-fun f4 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun g2 (Int Int) Int)
(declare-fun g3 () Int)
(declare-fun g4 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int Int) Int)
(declare-fun h2 () Int)
(declare-fun h3 (Int) Int)
(declare-fun h4 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun u4 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int) Int)
(declare-fun v2 (Int Int) Int)
(declare-fun v3 (Int) Int)
(declare-fun v4 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g1 1))
(assert (= g3 1))
(assert (= h0 1))
(assert (= h2 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int) (y Int)) (= (g2 x y) (- y 1))))
(assert (forall ((x Int)) (= (f1 x) (* x x))))
(assert (forall ((x Int)) (= (f3 x) (* x x))))
(assert (forall ((x Int)) (= (g4 x) (divf x 2))))
(assert (forall ((x Int)) (= (h4 x) (+ 1 (modf x 2)))))
(assert (forall ((x Int) (y Int)) (= (f4 x y) (* 2 (+ (- x (divf x y)) x)))))
(assert (forall ((x Int) (y Int)) (= (f2 x y) (divf (* x y) (- y (divf y 2))))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y) x)))))
(assert (forall ((x Int) (y Int)) (= (v2 x y) (u2 (g2 x y) h2))))
(assert (forall ((x Int) (y Int)) (= (h1 x y) (v2 x y))))
(assert (forall ((x Int) (y Int)) (= (u4 x y) (ite (<= x 0) y (f4 (u4 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v4 x) (u4 (g4 x) (h4 x)))))
(assert (forall ((x Int)) (= (h3 x) (v4 x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int) (y Int)) (= (v1 x y) (u1 g1 (h1 x y)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (v1 x y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y))))))
(assert (forall ((x Int)) (= (v3 x) (u3 g3 (h3 x)))))
(assert (forall ((x Int)) (= (fast x) (v3 x))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u1 x y))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f3 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f4 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u4 x y)))))
(assert (=> (forall ((x Int)) (= (f1 x) (f3 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x) (f4 x y))) (forall ((x Int) (y Int)) (= (u1 x y) (u4 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f2 x y) (f3 x))) (forall ((x Int) (y Int)) (= (u2 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f2 x y) (f4 x y))) (forall ((x Int) (y Int)) (= (u2 x y) (u4 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
