;; small program: ((x div (loop (1 + (x + x)) 2 2)) * (x mod (loop (1 + (x + x)) 2 2)))
;; K B K K D D C C J G K B K K D D C C J H F
;; fast program: ((x div (1 + (2 + (2 * (2 + 2))))) * (x mod (1 + (2 + (2 * (2 + 2))))))
;; K B C C C C D F D D G K B C C C C D F D D H F
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (f0 x) (+ 1 (+ x x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int)) (= (small x) (* (divf x v0) (modf x v0)))))
(assert (forall ((x Int)) (= (fast x) (* (divf x (+ 1 (+ 2 (* 2 (+ 2 2))))) (modf x (+ 1 (+ 2 (* 2 (+ 2 2)))))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
