;; small program: (1 + (((loop (0 - (x div 2)) x 2) + x) * x))
;; B A K C G E K C J K D K F D
;; fast program: (((loop ((x - y) + x) (1 + (2 - x)) x) * x) + 1)
;; K L E K D B C K E D K J K F B D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= h0 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ (- x y) x))))
(assert (forall ((x Int)) (= (g1 x) (+ 1 (- 2 x)))))
(assert (forall ((x Int)) (= (f0 x) (- 0 (divf x 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (small x) (+ 1 (* (+ (v0 x) x) x)))))
(assert (forall ((x Int)) (= (fast x) (+ (* (v1 x) x) 1))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
