;; small program: (if (((loop2 ((y mod 2) + x) (y div (2 - (x mod 2))) x 0 x) div 2) mod 2) <= 0 then (x mod 2) else 2)
;; L C H K D L C K C H E G K A K N C G C H K C H C I
;; fast program: (if (((loop2 ((y mod 2) + x) (y div (2 - (x mod 2))) (2 + (2 * (2 + 2))) 0 x) div 2) mod 2) <= 0 then (x mod 2) else 2)
;; L C H K D L C K C H E G C C C C D F D A K N C G C H K C H C I
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun i0 () Int)
(declare-fun i1 () Int)
(declare-fun j0 (Int) Int)
(declare-fun j1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int Int) Int)
(declare-fun u1 (Int Int Int) Int)
(declare-fun v0 (Int Int Int) Int)
(declare-fun v1 (Int Int Int) Int)
(declare-fun w0 (Int) Int)
(declare-fun w1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= i0 0))
(assert (= i1 0))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (j0 x) x)))
(assert (forall ((x Int)) (= (j1 x) x)))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (modf y 2) x))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ (modf y 2) x))))
(assert (= h1 (+ 2 (* 2 (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (g0 x y) (divf y (- 2 (modf x 2))))))
(assert (forall ((x Int) (y Int)) (= (g1 x y) (divf y (- 2 (modf x 2))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (ite (<= x 0) y (f0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (ite (<= x 0) z (g0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w0 x) (u0 (h0 x) i0 (j0 x)))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (ite (<= x 0) y (f1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (ite (<= x 0) z (g1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w1 x) (u1 h1 i1 (j1 x)))))
(assert (forall ((x Int)) (= (small x) (ite (<= (modf (divf (w0 x) 2) 2) 0) (modf x 2) 2))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (modf (divf (w1 x) 2) 2) 0) (modf x 2) 2))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (u0 x y z))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (v0 x y z))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
