;; small program: ((loop (loop2 ((((y mod 2) * 2) * x) + x) (y div 2) x 1 x) 1 (1 + x)) div (1 + 2))
;; L C H C F K F K D L C G K B K N B B K D J B C D G
;; fast program: ((loop2 ((((y mod 2) * 2) * x) + x) (y div 2) (1 + (2 + (2 + 2))) 1 (x + 1)) div (1 + 2))
;; L C H C F K F K D L C G B C C C D D D B K B D N B C D G
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 (Int Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 () Int)
(declare-fun i1 () Int)
(declare-fun i2 () Int)
(declare-fun j1 (Int) Int)
(declare-fun j2 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int Int) Int)
(declare-fun u2 (Int Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int Int) Int)
(declare-fun v2 (Int Int Int) Int)
(declare-fun w1 (Int) Int)
(declare-fun w2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 1))
(assert (= i1 1))
(assert (= i2 1))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (j1 x) x)))
(assert (forall ((x Int)) (= (h0 x) (+ 1 x))))
(assert (forall ((x Int)) (= (j2 x) (+ x 1))))
(assert (forall ((x Int) (y Int)) (= (g1 x y) (divf y 2))))
(assert (forall ((x Int) (y Int)) (= (g2 x y) (divf y 2))))
(assert (= h2 (+ 1 (+ 2 (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ (* (* (modf y 2) 2) x) x))))
(assert (forall ((x Int) (y Int)) (= (f2 x y) (+ (* (* (modf y 2) 2) x) x))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (ite (<= x 0) y (f1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (ite (<= x 0) z (g1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w1 x) (u1 (h1 x) i1 (j1 x)))))
(assert (forall ((x Int)) (= (f0 x) (w1 x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u2 x y z) (ite (<= x 0) y (f2 (u2 (- x 1) y z) (v2 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v2 x y z) (ite (<= x 0) z (g2 (u2 (- x 1) y z) (v2 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w2 x) (u2 h2 i2 (j2 x)))))
(assert (forall ((x Int)) (= (small x) (divf (v0 x) (+ 1 2)))))
(assert (forall ((x Int)) (= (fast x) (divf (w2 x) (+ 1 2)))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u2 x y z) (u1 x y z))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v2 x y z) (v1 x y z))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
