;; small program: (((loop ((x + x) + x) x 1) + x) mod (1 + (2 + (2 + 2))))
;; K K D K D K B J K D B C C C D D D H
;; fast program: (((loop ((x + x) + x) (x mod (2 + (2 + 2))) 1) + x) mod (1 + (2 + (2 + 2))))
;; K K D K D K C C C D D H B J K D B C C C D D D H
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f0 x) (+ (+ x x) x))))
(assert (forall ((x Int)) (= (f1 x) (+ (+ x x) x))))
(assert (forall ((x Int)) (= (g1 x) (modf x (+ 2 (+ 2 2))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (small x) (modf (+ (v0 x) x) (+ 1 (+ 2 (+ 2 2)))))))
(assert (forall ((x Int)) (= (fast x) (modf (+ (v1 x) x) (+ 1 (+ 2 (+ 2 2)))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
