;; small program: ((2 * (loop2 (y - x) x (x + x) 2 1)) + (loop (0 - x) x 2))
;; C L K E K K K D C B N F A K E K C J D
;; fast program: (((loop (2 + x) (x mod 2) (loop (x * x) 1 (loop2 (y - x) x x 2 1))) - 1) * 2)
;; C K D K C H K K F B L K E K K C B N J J B E C F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 (Int) Int)
(declare-fun f4 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 () Int)
(declare-fun g4 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 (Int) Int)
(declare-fun h3 (Int) Int)
(declare-fun h4 (Int) Int)
(declare-fun i0 () Int)
(declare-fun i4 () Int)
(declare-fun j0 () Int)
(declare-fun j4 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun u4 (Int Int Int) Int)
(declare-fun v0 (Int Int Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(declare-fun v4 (Int Int Int) Int)
(declare-fun w0 (Int) Int)
(declare-fun w4 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g3 1))
(assert (= j0 1))
(assert (= j4 1))
(assert (= h1 2))
(assert (= i0 2))
(assert (= i4 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (g4 x) x)))
(assert (forall ((x Int)) (= (h4 x) x)))
(assert (forall ((x Int)) (= (f2 x) (+ 2 x))))
(assert (forall ((x Int)) (= (h0 x) (+ x x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (- y x))))
(assert (forall ((x Int)) (= (f1 x) (- 0 x))))
(assert (forall ((x Int) (y Int)) (= (f4 x y) (- y x))))
(assert (forall ((x Int)) (= (f3 x) (* x x))))
(assert (forall ((x Int)) (= (g2 x) (modf x 2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u4 x y z) (ite (<= x 0) y (f4 (u4 (- x 1) y z) (v4 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v4 x y z) (ite (<= x 0) z (g4 (u4 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w4 x) (u4 (h4 x) i4 j4))))
(assert (forall ((x Int)) (= (h3 x) (w4 x))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (ite (<= x 0) y (f0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (ite (<= x 0) z (g0 (u0 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w0 x) (u0 (h0 x) i0 j0))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y))))))
(assert (forall ((x Int)) (= (v3 x) (u3 g3 (h3 x)))))
(assert (forall ((x Int)) (= (h2 x) (v3 x))))
(assert (forall ((x Int)) (= (small x) (+ (* 2 (w0 x)) (v1 x)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) (h2 x)))))
(assert (forall ((x Int)) (= (fast x) (* (- (v2 x) 1) 2))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u4 x y z) (u0 x y z))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v4 x y z) (v0 x y z))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
