;; small program: (((loop (if ((1 + x) mod (1 + (2 + 2))) <= 0 then (x div (1 + (2 + 2))) else x) 2 x) mod (1 + (2 + 2))) div 2)
;; B K D B C C D D H K B C C D D G K I C K J B C C D D H C G
;; fast program: (if (((loop (if ((1 + x) mod (1 + (2 + 2))) <= 0 then (x div (1 + (2 + 2))) else x) 2 x) mod (1 + (2 + 2))) - 1) <= 0 then 0 else 1)
;; B K D B C C D D H K B C C D D G K I C K J B C C D D H B E A B I
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun h0 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (f0 x) (ite (<= (modf (+ 1 x) (+ 1 (+ 2 2))) 0) (divf x (+ 1 (+ 2 2))) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (divf (modf (v0 x) (+ 1 (+ 2 2))) 2))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (- (modf (v0 x) (+ 1 (+ 2 2))) 1) 0) 0 1))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
