;; small program: (((loop (((1 + (loop ((x mod y) + y) (2 + x) 0)) + x) div 2) x 2) * 2) + 1)
;; B K L H L D C K D A J D K D C G K C J C F B D
;; fast program: (((loop ((((((1 + (loop ((x mod y) + y) ((1 + x) div (2 + 2)) 0)) * (if x <= 0 then 1 else 2)) * 2) + 1) + x) div 2) x (1 + 2)) * 2) - 1)
;; B K L H L D B K D C C D G A J D K B C I F C F B D K D C G K B C D J C F B E
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun h3 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h1 0))
(assert (= h3 0))
(assert (= h0 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g2 x) x)))
(assert (forall ((x Int)) (= (g1 x) (+ 2 x))))
(assert (= h2 (+ 1 2)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ (modf x y) y))))
(assert (forall ((x Int) (y Int)) (= (f3 x y) (+ (modf x y) y))))
(assert (forall ((x Int)) (= (g3 x) (divf (+ 1 x) (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) h3))))
(assert (forall ((x Int)) (= (f0 x) (divf (+ (+ 1 (v1 x)) x) 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (+ (* (v0 x) 2) 1))))
(assert (forall ((x Int)) (= (f2 x) (divf (+ (+ (* (* (+ 1 (v3 x)) (ite (<= x 0) 1 2)) 2) 1) x) 2))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int)) (= (fast x) (- (* (v2 x) 2) 1))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u1 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
