;; small program: (compr (((loop (if (x mod (1 + 2)) <= 0 then (x div (1 + 2)) else x) x (x - 1)) mod (1 + 2)) mod 2) (1 + x))
;; K B C D H K B C D G K I K K B E J B C D H C H B K D M
;; fast program: (((((compr ((((loop (if (x mod (1 + 2)) <= 0 then (x div (1 + 2)) else x) (loop (y - x) (x - 1) 1) x) mod (1 + 2)) mod 2) mod (1 + x)) x) * 2) + 1) + 2) div 2)
;; K B C D H K B C D G K I L K E K B E B J K J B C D H C H B K D H K M C F B D C D C G
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 (Int) Int)
(declare-fun f4 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 (Int) Int)
(declare-fun g4 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun h3 (Int) Int)
(declare-fun h4 () Int)
(declare-fun small (Int) Int)
(declare-fun t0 (Int) Int)
(declare-fun t2 (Int) Int)
(declare-fun u0 (Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun u4 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(declare-fun v4 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h4 1))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (g2 x) x)))
(assert (forall ((x Int)) (= (h3 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ 1 x))))
(assert (forall ((x Int) (y Int)) (= (f4 x y) (- y x))))
(assert (forall ((x Int)) (= (g4 x) (- x 1))))
(assert (forall ((x Int)) (= (h1 x) (- x 1))))
(assert (forall ((x Int) (y Int)) (= (u4 x y) (ite (<= x 0) y (f4 (u4 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v4 x) (u4 (g4 x) h4))))
(assert (forall ((x Int)) (= (g3 x) (v4 x))))
(assert (forall ((x Int)) (= (f1 x) (ite (<= (modf x (+ 1 2)) 0) (divf x (+ 1 2)) x))))
(assert (forall ((x Int)) (= (f3 x) (ite (<= (modf x (+ 1 2)) 0) (divf x (+ 1 2)) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y))))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x) (h3 x)))))
(assert (forall ((x Int)) (= (f0 x) (modf (modf (v1 x) (+ 1 2)) 2))))
(assert (forall ((x Int)) (= (t0 x) (ite (<= (f0 x) 0) x (t0 (+ x 1))))))
(assert (forall ((x Int)) (= (u0 x) (ite (<= x 0) (t0 0) (t0 (+ (u0 (- x 1)) 1))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x)))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (f2 x) (modf (modf (modf (v3 x) (+ 1 2)) 2) (+ 1 x)))))
(assert (forall ((x Int)) (= (t2 x) (ite (<= (f2 x) 0) x (t2 (+ x 1))))))
(assert (forall ((x Int)) (= (u2 x) (ite (<= x 0) (t2 0) (t2 (+ (u2 (- x 1)) 1))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x)))))
(assert (forall ((x Int)) (= (fast x) (divf (+ (+ (* (v2 x) 2) 1) 2) 2))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u1 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
