;; small program: ((((loop ((1 + (2 + y)) * (x * y)) x (1 + 2)) div 2) - (x mod 2)) mod (loop (x + x) x 2))
;; B C L D D K L F F K B C D J C G K C H E K K D K C J H
;; fast program: (((loop (x + x) ((((x div 2) + x) div (1 + (2 + 2))) + x) 1) - (x mod 2)) mod (loop (x + x) x 2))
;; K K D K C G K D B C C D D G K D B J K C H E K K D K C J H
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h2 1))
(assert (= h1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (f1 x) (+ x x))))
(assert (forall ((x Int)) (= (f2 x) (+ x x))))
(assert (= h0 (+ 1 2)))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* (+ 1 (+ 2 y)) (* x y)))))
(assert (forall ((x Int)) (= (g2 x) (+ (divf (+ (divf x 2) x) (+ 1 (+ 2 2))) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int)) (= (small x) (modf (- (divf (v0 x) 2) (modf x 2)) (v1 x)))))
(assert (forall ((x Int)) (= (fast x) (modf (- (v2 x) (modf x 2)) (v1 x)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u3 x y))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u1 x y))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u1 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
