;; small program: (((1 + (loop (x + x) x 1)) div (2 + x)) * (if (x - 1) <= 0 then 1 else 2))
;; B K K D K B J D C K D G K B E B C I F
;; fast program: (((1 + (loop (x + x) x 1)) div (2 + x)) * (loop 1 (2 - x) 2))
;; B K K D K B J D C K D G B C K E C J F
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= f1 1))
(assert (= h0 1))
(assert (= h1 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f0 x) (+ x x))))
(assert (forall ((x Int)) (= (g1 x) (- 2 x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (* (divf (+ 1 (v0 x)) (+ 2 x)) (v1 x)))))
(assert (forall ((x Int)) (= (small x) (* (divf (+ 1 (v0 x)) (+ 2 x)) (ite (<= (- x 1) 0) 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
