;; small program: (((loop ((2 + y) * x) (2 + ((x + x) + x)) 1) div 2) div (2 + ((x + x) + x)))
;; C L D K F C K K D K D D B J C G C K K D K D D G
;; fast program: (((loop ((2 + y) * x) (2 + ((x + x) + x)) 1) div (2 + ((x + x) + x))) div 2)
;; C L D K F C K K D K D D B J C K K D K D D G C G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= h0 1))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* (+ 2 y) x))))
(assert (forall ((x Int)) (= (g0 x) (+ 2 (+ (+ x x) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (fast x) (divf (divf (v0 x) (+ 2 (+ (+ x x) x))) 2))))
(assert (forall ((x Int)) (= (small x) (divf (divf (v0 x) 2) (+ 2 (+ (+ x x) x))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
