;; small program: ((loop2 (loop2 (x + y) x y x 0) (y div 2) x 1 x) mod 2)
;; K L D K L K A N L C G K B K N C H
;; fast program: (if ((loop2 ((x * y) + x) (y div 2) (2 + (2 + 2)) 1 x) mod (1 + 2)) <= 0 then 0 else 1)
;; K L F K D L C G C C C D D B K N B C D H A B I
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int Int) Int)
(declare-fun h2 () Int)
(declare-fun i0 () Int)
(declare-fun i1 (Int) Int)
(declare-fun i2 () Int)
(declare-fun j0 (Int) Int)
(declare-fun j1 () Int)
(declare-fun j2 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int Int) Int)
(declare-fun u1 (Int Int Int) Int)
(declare-fun u2 (Int Int Int) Int)
(declare-fun v0 (Int Int Int) Int)
(declare-fun v1 (Int Int Int) Int)
(declare-fun v2 (Int Int Int) Int)
(declare-fun w0 (Int) Int)
(declare-fun w1 (Int Int) Int)
(declare-fun w2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= j1 0))
(assert (= i0 1))
(assert (= i2 1))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (i1 x) x)))
(assert (forall ((x Int)) (= (j0 x) x)))
(assert (forall ((x Int)) (= (j2 x) x)))
(assert (forall ((x Int) (y Int)) (= (h1 x y) y)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ x y))))
(assert (forall ((x Int) (y Int)) (= (g0 x y) (divf y 2))))
(assert (forall ((x Int) (y Int)) (= (g2 x y) (divf y 2))))
(assert (forall ((x Int) (y Int)) (= (f2 x y) (+ (* x y) x))))
(assert (= h2 (+ 2 (+ 2 2))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (ite (<= x 0) y (f1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (ite (<= x 0) z (g1 (u1 (- x 1) y z))))))
(assert (forall ((x Int) (y Int)) (= (w1 x y) (u1 (h1 x y) (i1 x) j1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (w1 x y))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (ite (<= x 0) y (f0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (ite (<= x 0) z (g0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w0 x) (u0 (h0 x) i0 (j0 x)))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u2 x y z) (ite (<= x 0) y (f2 (u2 (- x 1) y z) (v2 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v2 x y z) (ite (<= x 0) z (g2 (u2 (- x 1) y z) (v2 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w2 x) (u2 h2 i2 (j2 x)))))
(assert (forall ((x Int)) (= (small x) (modf (w0 x) 2))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (modf (w2 x) (+ 1 2)) 0) 0 1))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v2 x y z) (v0 x y z))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
