;; small program: ((loop (x * y) (x - 1) 1) * (loop (((x * x) - x) div 2) 2 x))
;; K L F K B E B J K K F K E C G C K J F
;; fast program: (((loop ((x - 2) * x) 1 ((x * x) - x)) div (2 * (2 + 2))) * (loop (x * y) (x - 1) 1))
;; K C E K F B K K F K E J C C C D F G K L F K B E B J F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun g2 () Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g2 1))
(assert (= h0 1))
(assert (= g1 2))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g0 x) (- x 1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* x y))))
(assert (forall ((x Int)) (= (h2 x) (- (* x x) x))))
(assert (forall ((x Int)) (= (f2 x) (* (- x 2) x))))
(assert (forall ((x Int)) (= (f1 x) (divf (- (* x x) x) 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 g2 (h2 x)))))
(assert (forall ((x Int)) (= (small x) (* (v0 x) (v1 x)))))
(assert (forall ((x Int)) (= (fast x) (* (divf (v2 x) (* 2 (+ 2 2))) (v0 x)))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
