;; small program: (((((1 + x) * (loop (1 + ((x * x) * x)) 2 2)) + (x div 2)) div 2) + 1)
;; B K D B K K F K F D C C J F K C G D C G B D
;; fast program: (((((2 * (loop (1 + ((x * x) * x)) 2 2)) * (1 + x)) + x) div (2 + 2)) + 1)
;; C B K K F K F D C C J F B K D F K D C C D G B D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (f0 x) (+ 1 (* (* x x) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int)) (= (small x) (+ (divf (+ (* (+ 1 x) v0) (divf x 2)) 2) 1))))
(assert (forall ((x Int)) (= (fast x) (+ (divf (+ (* (* 2 v0) (+ 1 x)) x) (+ 2 2)) 1))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
