;; small program: (((loop (1 + ((x div (1 + (x mod (2 + 2)))) + x)) (1 + x) 2) div 2) div 2)
;; B K B K C C D H D G K D D B K D C J C G C G
;; fast program: (((loop (1 + ((x div (1 + (x mod (2 + 2)))) + x)) x (1 + 2)) div 2) div 2)
;; B K B K C C D H D G K D D K B C D J C G C G
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 2))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ 1 x))))
(assert (= h1 (+ 1 2)))
(assert (forall ((x Int)) (= (f0 x) (+ 1 (+ (divf x (+ 1 (modf x (+ 2 2)))) x)))))
(assert (forall ((x Int)) (= (f1 x) (+ 1 (+ (divf x (+ 1 (modf x (+ 2 2)))) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (divf (divf (v1 x) 2) 2))))
(assert (forall ((x Int)) (= (small x) (divf (divf (v0 x) 2) 2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
