;; small program: (((if ((loop (x * y) x 1) mod (1 + x)) <= 0 then 1 else 0) * (loop (x * y) x 1)) div (1 + x))
;; K L F K B J B K D H B A I K L F K B J F B K D G
;; fast program: (((if ((loop (x * y) (x - 2) 1) mod (1 + x)) <= 0 then 1 else 0) * (loop (x * y) x 1)) div (1 + x))
;; K L F K C E B J B K D H B A I K L F K B J F B K D G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) (- x 2))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (small x) (divf (* (ite (<= (modf (v0 x) (+ 1 x)) 0) 1 0) (v0 x)) (+ 1 x)))))
(assert (forall ((x Int)) (= (fast x) (divf (* (ite (<= (modf (v1 x) (+ 1 x)) 0) 1 0) (v0 x)) (+ 1 x)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u3 x y))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u0 x y))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u1 x y))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u0 x y))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (u1 x y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
