;; small program: ((((loop2 (1 + (x * y)) (y - 1) x 0 x) div 2) * (x - 1)) * x)
;; B K L F D L B E K A K N C G K B E F K F
;; fast program: (((loop2 (1 + (x * y)) (y - 1) x 0 x) div 2) * ((x * x) - x))
;; B K L F D L B E K A K N C G K K F K E F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun i0 () Int)
(declare-fun j0 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int Int) Int)
(declare-fun v0 (Int Int Int) Int)
(declare-fun w0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= i0 0))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (j0 x) x)))
(assert (forall ((x Int) (y Int)) (= (g0 x y) (- y 1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ 1 (* x y)))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (ite (<= x 0) y (f0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (ite (<= x 0) z (g0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w0 x) (u0 (h0 x) i0 (j0 x)))))
(assert (forall ((x Int)) (= (fast x) (* (divf (w0 x) 2) (- (* x x) x)))))
(assert (forall ((x Int)) (= (small x) (* (* (divf (w0 x) 2) (- x 1)) x))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (u0 x y z))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (v0 x y z))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
