;; small program: (if ((1 + (x div (loop 1 (x mod (2 + 2)) (2 + 2)))) mod (2 * (2 + 2))) <= 0 then 1 else 0)
;; B K B K C C D H C C D J G D C C C D F H B A I
;; fast program: (if (((loop (x div (loop 1 (x mod 2) (2 + 2))) (if (x mod (2 + 2)) <= 0 then 1 else 0) x) + 1) mod (2 * (2 + 2))) <= 0 then 1 else 0)
;; K B K C H C C D J G K C C D H B A I K J B D C C C D F H B A I
(set-logic UFNIA)
(declare-fun f0 () Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f0 1))
(assert (= f2 1))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (= h0 (+ 2 2)))
(assert (= h2 (+ 2 2)))
(assert (forall ((x Int)) (= (g2 x) (modf x 2))))
(assert (forall ((x Int)) (= (g0 x) (modf x (+ 2 2)))))
(assert (forall ((x Int)) (= (g1 x) (ite (<= (modf x (+ 2 2)) 0) 1 0))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y f2))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int)) (= (f1 x) (divf x (v2 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y f0))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (small x) (ite (<= (modf (+ 1 (divf x (v0 x))) (* 2 (+ 2 2))) 0) 1 0))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (modf (+ (v1 x) 1) (* 2 (+ 2 2))) 0) 1 0))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
