;; small program: (((loop ((x * x) - x) 1 (((x * x) * x) * x)) div (1 + 2)) div (loop ((2 + x) * x) 2 2))
;; K K F K E B K K F K F K F J B C D G C K D K F C C J G
;; fast program: (((loop ((x * x) - x) 1 (((x * x) * x) * x)) div (2 + 2)) div (loop (((x * x) * x) - x) 1 (2 + 2)))
;; K K F K E B K K F K F K F J C C D G K K F K F K E B C C D J G
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun g2 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(declare-fun v2 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g0 1))
(assert (= g2 1))
(assert (= g1 2))
(assert (= h1 2))
(assert (= h2 (+ 2 2)))
(assert (forall ((x Int)) (= (f0 x) (- (* x x) x))))
(assert (forall ((x Int)) (= (f1 x) (* (+ 2 x) x))))
(assert (forall ((x Int)) (= (f2 x) (- (* (* x x) x) x))))
(assert (forall ((x Int)) (= (h0 x) (* (* (* x x) x) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (= v2 (u2 g2 h2)))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (divf (divf (v0 x) (+ 1 2)) v1))))
(assert (forall ((x Int)) (= (fast x) (divf (divf (v0 x) (+ 2 2)) v2))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
