;; small program: ((loop (0 - x) x (1 + (x + x))) mod (1 + (2 * (2 + 2))))
;; A K E K B K K D D J B C C C D F D H
;; fast program: ((loop (0 - x) (x mod 2) (1 + (x + x))) mod (1 + (2 * (2 + 2))))
;; A K E K C H B K K D D J B C C C D F D H
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f0 x) (- 0 x))))
(assert (forall ((x Int)) (= (f1 x) (- 0 x))))
(assert (forall ((x Int)) (= (g1 x) (modf x 2))))
(assert (forall ((x Int)) (= (h0 x) (+ 1 (+ x x)))))
(assert (forall ((x Int)) (= (h1 x) (+ 1 (+ x x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) (+ 1 (* 2 (+ 2 2)))))))
(assert (forall ((x Int)) (= (fast x) (modf (v1 x) (+ 1 (* 2 (+ 2 2)))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
