;; small program: (((loop2 (1 - (y + y)) (x - y) x 2 1) + (loop (x + x) x 1)) div (1 + 2))
;; B L L D E K L E K C B N K K D K B J D B C D G
;; fast program: (((loop2 (1 - (y + y)) (x - y) x 2 1) + (loop (x + x) (x - 1) 2)) div (1 + 2))
;; B L L D E K L E K C B N K K D K B E C J D B C D G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun i0 () Int)
(declare-fun j0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int Int Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun w0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= h1 1))
(assert (= j0 1))
(assert (= h2 2))
(assert (= i0 2))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (f1 x) (+ x x))))
(assert (forall ((x Int)) (= (f2 x) (+ x x))))
(assert (forall ((x Int) (y Int)) (= (g0 x y) (- x y))))
(assert (forall ((x Int)) (= (g2 x) (- x 1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (- 1 (+ y y)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (ite (<= x 0) y (f0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (ite (<= x 0) z (g0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w0 x) (u0 (h0 x) i0 j0))))
(assert (forall ((x Int)) (= (small x) (divf (+ (w0 x) (v1 x)) (+ 1 2)))))
(assert (forall ((x Int)) (= (fast x) (divf (+ (w0 x) (v2 x)) (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u1 x y))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (u0 x y z))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (v0 x y z))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
