;; small program: (loop2 (x + y) (y div 2) x 0 (loop2 (x * y) (y + y) x 1 1))
;; K L D L C G K A K L F L L D K B B N N
;; fast program: (((loop (x + x) x 1) - 1) * (loop2 (x * y) (y + y) (x - 2) 1 2))
;; K K D K B J B E K L F L L D K C E B C N F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 (Int Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 () Int)
(declare-fun h3 (Int) Int)
(declare-fun i0 () Int)
(declare-fun i1 () Int)
(declare-fun i3 () Int)
(declare-fun j0 (Int) Int)
(declare-fun j1 () Int)
(declare-fun j3 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int Int) Int)
(declare-fun u1 (Int Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int Int) Int)
(declare-fun v0 (Int Int Int) Int)
(declare-fun v1 (Int Int Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int Int Int) Int)
(declare-fun w0 (Int) Int)
(declare-fun w1 (Int) Int)
(declare-fun w3 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= i0 0))
(assert (= h2 1))
(assert (= i1 1))
(assert (= i3 1))
(assert (= j1 1))
(assert (= j3 2))
(assert (forall ((x Int)) (= (g2 x) x)))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ x y))))
(assert (forall ((x Int)) (= (f2 x) (+ x x))))
(assert (forall ((x Int) (y Int)) (= (g1 x y) (+ y y))))
(assert (forall ((x Int) (y Int)) (= (g3 x y) (+ y y))))
(assert (forall ((x Int)) (= (h3 x) (- x 2))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (f3 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (g0 x y) (divf y 2))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u1 x y z) (ite (<= x 0) y (f1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v1 x y z) (ite (<= x 0) z (g1 (u1 (- x 1) y z) (v1 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w1 x) (u1 (h1 x) i1 j1))))
(assert (forall ((x Int)) (= (j0 x) (w1 x))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u3 x y z) (ite (<= x 0) y (f3 (u3 (- x 1) y z) (v3 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v3 x y z) (ite (<= x 0) z (g3 (u3 (- x 1) y z) (v3 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w3 x) (u3 (h3 x) i3 j3))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u0 x y z) (ite (<= x 0) y (f0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v0 x y z) (ite (<= x 0) z (g0 (u0 (- x 1) y z) (v0 (- x 1) y z))))))
(assert (forall ((x Int)) (= (w0 x) (u0 (h0 x) i0 (j0 x)))))
(assert (forall ((x Int)) (= (small x) (w0 x))))
(assert (forall ((x Int)) (= (fast x) (* (- (v2 x) 1) (w3 x)))))
(assert (forall ((x Int) (y Int) (z Int)) (= (u3 x y z) (u1 x y z))))
(assert (forall ((x Int) (y Int) (z Int)) (= (v3 x y z) (v1 x y z))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
