;; small program: ((((((1 - x) * ((2 - x) * x)) div (1 + 2)) * (loop (x * y) x 1)) div (2 + 2)) div (1 + 2))
;; B K E C K E K F F B C D G K L F K B J F C C D G B C D G
;; fast program: ((((((1 - x) * ((2 - x) * x)) div (2 + (2 + 2))) * (loop (x * y) x 1)) div (1 + 2)) div 2)
;; B K E C K E K F F C C C D D G K L F K B J F B C D G C G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= h0 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* x y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (fast x) (divf (divf (* (divf (* (- 1 x) (* (- 2 x) x)) (+ 2 (+ 2 2))) (v0 x)) (+ 1 2)) 2))))
(assert (forall ((x Int)) (= (small x) (divf (divf (* (divf (* (- 1 x) (* (- 2 x) x)) (+ 1 2)) (v0 x)) (+ 2 2)) (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
