;; small program: (loop ((x div 2) - x) (x mod (1 + (loop ((1 + 2) + (x * x)) 2 2))) 1)
;; K C G K E K B B C D K K F D C C J D H B J
;; fast program: (loop ((x div 2) - x) (x mod ((2 * (loop ((x * x) * x) 1 (1 + 2))) - 1)) 1)
;; K C G K E K C K K F K F B B C D J F B E H B J
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun f3 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun h3 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g3 1))
(assert (= h0 1))
(assert (= h2 1))
(assert (= g1 2))
(assert (= h1 2))
(assert (= h3 (+ 1 2)))
(assert (forall ((x Int)) (= (f0 x) (- (divf x 2) x))))
(assert (forall ((x Int)) (= (f2 x) (- (divf x 2) x))))
(assert (forall ((x Int)) (= (f3 x) (* (* x x) x))))
(assert (forall ((x Int)) (= (f1 x) (+ (+ 1 2) (* x x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y))))))
(assert (= v3 (u3 g3 h3)))
(assert (forall ((x Int)) (= (g0 x) (modf x (+ 1 v1)))))
(assert (forall ((x Int)) (= (g2 x) (modf x (- (* 2 v3) 1)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int)) (= (fast x) (v2 x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
