;; small program: (((loop 1 ((2 + x) mod (2 + 2)) 2) * (if (x mod (1 + 2)) <= 0 then 1 else 0)) + 2)
;; B C K D C C D H C J K B C D H B A I F C D
;; fast program: (((loop 1 ((2 - x) mod (2 + 2)) 2) * (loop 0 (x mod (1 + 2)) 1)) + 2)
;; B C K E C C D H C J A K B C D H B J F C D
(set-logic UFNIA)
(declare-fun f0 () Int)
(declare-fun f1 () Int)
(declare-fun f2 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f2 0))
(assert (= f0 1))
(assert (= f1 1))
(assert (= h2 1))
(assert (= h0 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (g2 x) (modf x (+ 1 2)))))
(assert (forall ((x Int)) (= (g0 x) (modf (+ 2 x) (+ 2 2)))))
(assert (forall ((x Int)) (= (g1 x) (modf (- 2 x) (+ 2 2)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y f2))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y f0))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (+ (* (v1 x) (v2 x)) 2))))
(assert (forall ((x Int)) (= (small x) (+ (* (v0 x) (ite (<= (modf x (+ 1 2)) 0) 1 0)) 2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
