;; small program: ((1 + (loop (2 * ((x - (x div y)) + x)) (x + x) 1)) div 2)
;; B C K K L G E K D F K K D B J D C G
;; fast program: ((loop (2 * ((x - (x div y)) + x)) (x + x) 1) div (if x <= 0 then 1 else 2))
;; C K K L G E K D F K K D B J K B C I G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= h0 1))
(assert (forall ((x Int)) (= (g0 x) (+ x x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* 2 (+ (- x (divf x y)) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (divf (+ 1 (v0 x)) 2))))
(assert (forall ((x Int)) (= (fast x) (divf (v0 x) (ite (<= x 0) 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
