;; small program: ((loop ((y mod 2) - 1) (x - 1) 1) mod (loop (x + x) x 2))
;; L C H B E K B E B J K K D K C J H
;; fast program: ((if ((x * x) - x) <= 0 then 1 else (((x - x) div 2) - (x mod 2))) mod (loop (x + x) x 2))
;; K K F K E B K K E C G K C H E I K K D K C J H
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h1 2))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (f1 x) (+ x x))))
(assert (forall ((x Int)) (= (g0 x) (- x 1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (- (modf y 2) 1))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) (v1 x)))))
(assert (forall ((x Int)) (= (fast x) (modf (ite (<= (- (* x x) x) 0) 1 (- (divf (- x x) 2) (modf x 2))) (v1 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u1 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
