;; small program: ((((((loop (x * x) 1 (2 + ((x div 2) - (x mod 2)))) div (1 + 2)) div 2) + 1) div 2) * (1 + x))
;; K K F B C K C G K C H E D J B C D G C G B D C G B K D F
;; fast program: (((((loop (x * x) 1 (2 + ((x div 2) - (x mod 2)))) div (2 + (2 + 2))) + 1) div 2) * (1 + x))
;; K K F B C K C G K C H E D J C C C D D G B D C G B K D F
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun h0 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 1))
(assert (forall ((x Int)) (= (f0 x) (* x x))))
(assert (forall ((x Int)) (= (h0 x) (+ 2 (- (divf x 2) (modf x 2))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (fast x) (* (divf (+ (divf (v0 x) (+ 2 (+ 2 2))) 1) 2) (+ 1 x)))))
(assert (forall ((x Int)) (= (small x) (* (divf (+ (divf (divf (v0 x) (+ 1 2)) 2) 1) 2) (+ 1 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
