;; small program: (((loop (2 * ((x - (x div y)) + x)) ((1 + x) div (1 + 2)) 1) div (1 + (x mod 2))) div 2)
;; C K K L G E K D F B K D B C D G B J B K C H D G C G
;; fast program: ((loop (2 * ((x - (x div y)) + x)) ((1 + x) div (1 + 2)) 1) div ((1 + (x mod 2)) * 2))
;; C K K L G E K D F B K D B C D G B J B K C H D C F G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (forall ((x Int)) (= (g0 x) (divf (+ 1 x) (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* 2 (+ (- x (divf x y)) x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (fast x) (divf (v0 x) (* (+ 1 (modf x 2)) 2)))))
(assert (forall ((x Int)) (= (small x) (divf (divf (v0 x) (+ 1 (modf x 2))) 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
