;; small program: (if ((((2 * (loop (x * x) 2 2)) - 1) * (loop (x * x) 1 (1 + (2 + 2)))) mod (2 + x)) <= 0 then 1 else 0)
;; C K K F C C J F B E K K F B B C C D D J F C K D H B A I
;; fast program: (if ((((2 * (2 * (2 * (2 + 2)))) - 1) * (loop (x * x) 1 (1 + (2 + 2)))) mod (2 + x)) <= 0 then 1 else 0)
;; C C C C C D F F F B E K K F B B C C D D J F C K D H B A I
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g1 1))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (f0 x) (* x x))))
(assert (forall ((x Int)) (= (f1 x) (* x x))))
(assert (= h1 (+ 1 (+ 2 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (small x) (ite (<= (modf (* (- (* 2 v0) 1) v1) (+ 2 x)) 0) 1 0))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (modf (* (- (* 2 (* 2 (* 2 (+ 2 2)))) 1) v1) (+ 2 x)) 0) 1 0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u1 x y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
