;; small program: ((loop (compr ((loop ((x * y) div (y - (y div 2))) (1 + x) 1) mod (1 + x)) y) x 0) + 1)
;; K L F L L C G E G B K D B J B K D H L M K A J B D
;; fast program: (((compr ((loop ((x * y) div (y - (y div 2))) (1 + x) 1) mod (1 + x)) x) + 1) div (1 mod 2))
;; K L F L L C G E G B K D B J B K D H K M B D B C H G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun f3 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun g3 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun t1 (Int) Int)
(declare-fun t3 (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int) Int)
(declare-fun v2 (Int) Int)
(declare-fun v3 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 0))
(assert (= h2 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g3 x) x)))
(assert (forall ((x Int) (y Int)) (= (g1 x y) y)))
(assert (forall ((x Int)) (= (g2 x) (+ 1 x))))
(assert (forall ((x Int) (y Int)) (= (f2 x y) (divf (* x y) (- y (divf y 2))))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int)) (= (f1 x) (modf (v2 x) (+ 1 x)))))
(assert (forall ((x Int)) (= (f3 x) (modf (v2 x) (+ 1 x)))))
(assert (forall ((x Int)) (= (t1 x) (ite (<= (f1 x) 0) x (t1 (+ x 1))))))
(assert (forall ((x Int)) (= (u1 x) (ite (<= x 0) (t1 0) (t1 (+ (u1 (- x 1)) 1))))))
(assert (forall ((x Int) (y Int)) (= (v1 x y) (u1 (g1 x y)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (v1 x y))))
(assert (forall ((x Int)) (= (t3 x) (ite (<= (f3 x) 0) x (t3 (+ x 1))))))
(assert (forall ((x Int)) (= (u3 x) (ite (<= x 0) (t3 0) (t3 (+ (u3 (- x 1)) 1))))))
(assert (forall ((x Int)) (= (v3 x) (u3 (g3 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (+ (v0 x) 1))))
(assert (forall ((x Int)) (= (fast x) (divf (+ (v3 x) 1) (modf 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u2 x y))))
(assert (forall ((x Int)) (= (u3 x) (u1 x))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
