;; small program: (((1 + (((1 + x) div ((loop (x * x) 2 2) - 1)) + x)) * (loop (x * x) 2 2)) - 1)
;; B B K D K K F C C J B E G K D D K K F C C J F B E
;; fast program: (((1 + (((1 + x) div ((2 * (2 * (2 + 2))) - 1)) + x)) * (2 * (2 * (2 + 2)))) - 1)
;; B B K D C C C C D F F B E G K D D C C C C D F F F B E
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (f0 x) (* x x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int)) (= (small x) (- (* (+ 1 (+ (divf (+ 1 x) (- v0 1)) x)) v0) 1))))
(assert (forall ((x Int)) (= (fast x) (- (* (+ 1 (+ (divf (+ 1 x) (- (* 2 (* 2 (+ 2 2))) 1)) x)) (* 2 (* 2 (+ 2 2)))) 1))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
