;; small program: ((if ((1 + x) mod (loop (x * x) 2 2)) <= 0 then ((x div 2) div (2 * (2 + 2))) else x) + 1)
;; B K D K K F C C J H K C G C C C D F G K I B D
;; fast program: ((loop (if ((1 + x) mod (loop (x * x) 2 2)) <= 0 then (x div (((2 + 2) * 2) * 2)) else x) (x mod 2) x) + 1)
;; B K D K K F C C J H K C C D C F C F G K I K C H K J B D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (f0 x) (* x x))))
(assert (forall ((x Int)) (= (g1 x) (modf x 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int)) (= (f1 x) (ite (<= (modf (+ 1 x) v0) 0) (divf x (* (* (+ 2 2) 2) 2)) x))))
(assert (forall ((x Int)) (= (small x) (+ (ite (<= (modf (+ 1 x) v0) 0) (divf (divf x 2) (* 2 (+ 2 2))) x) 1))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (+ (v1 x) 1))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
