;; small program: (loop (2 * ((x + x) + x)) ((((x mod (1 + 2)) + x) + x) + x) 1)
;; C K K D K D F K B C D H K D K D K D B J
;; fast program: (loop ((loop (2 * ((x + x) + x)) (if (y mod (1 + 2)) <= 0 then 1 else (2 + 2)) 1) * x) x 1)
;; C K K D K D F L B C D H B C C D I B J K F K B J
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (= h1 1))
(assert (= h2 1))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (f0 x) (* 2 (+ (+ x x) x)))))
(assert (forall ((x Int)) (= (f2 x) (* 2 (+ (+ x x) x)))))
(assert (forall ((x Int) (y Int)) (= (g2 x y) (ite (<= (modf y (+ 1 2)) 0) 1 (+ 2 2)))))
(assert (forall ((x Int)) (= (g0 x) (+ (+ (+ (modf x (+ 1 2)) x) x) x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int) (y Int)) (= (v2 x y) (u2 (g2 x y) h2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* (v2 x y) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (v1 x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
