;; small program: (((loop ((y * y) + x) x (x * x)) * (loop (x + x) x 1)) div (2 + 2))
;; L L F K D K K K F J K K D K B J F C C D G
;; fast program: (((((((1 + (x + x)) * ((x * x) + x)) div (2 + (2 + 2))) + (x * x)) * (loop (x + x) x 1)) div 2) div 2)
;; B K K D D K K F K D F C C C D D G K K F D K K D K B J F C G C G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (f1 x) (+ x x))))
(assert (forall ((x Int)) (= (h0 x) (* x x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (* y y) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (divf (* (v0 x) (v1 x)) (+ 2 2)))))
(assert (forall ((x Int)) (= (fast x) (divf (divf (* (+ (divf (* (+ 1 (+ x x)) (+ (* x x) x)) (+ 2 (+ 2 2))) (* x x)) (v1 x)) 2) 2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u1 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
