;; small program: (loop (((1 + (y + y)) * (2 * x)) div (2 + y)) (x div 2) (1 - ((0 - (x mod 2)) mod (2 + 2))))
;; B L L D D C K F F C L D G K C G B A K C H E C C D H E J
;; fast program: (loop (((1 + (y + y)) * (2 * x)) div (2 + y)) (x div 2) (1 - (((2 + x) * x) mod (2 + 2))))
;; B L L D D C K F F C L D G K C G B C K D K F C C D H E J
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (forall ((x Int)) (= (g0 x) (divf x 2))))
(assert (forall ((x Int)) (= (g1 x) (divf x 2))))
(assert (forall ((x Int)) (= (h0 x) (- 1 (modf (- 0 (modf x 2)) (+ 2 2))))))
(assert (forall ((x Int)) (= (h1 x) (- 1 (modf (* (+ 2 x) x) (+ 2 2))))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (divf (* (+ 1 (+ y y)) (* 2 x)) (+ 2 y)))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (divf (* (+ 1 (+ y y)) (* 2 x)) (+ 2 y)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (v1 x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
